<?php
get_header();
?>
<div id="et-main-area">
    <div id="main-content">
        <div class=" et_pb_row et_pb_row_0 featured-slider-section">
            <?php 
                echo do_shortcode('[featured_slider]');
            ?>
            
            <div class="title_row1 category-template2">
                <div class="page_title1">
                    <h1>
                        <strong>
                            Our Products
                        </strong>
                        <i class="fa fa-angle-right" aria-hidden="true"></i>
                        <?php 
                            $term1 = get_term_by( 'slug', get_query_var('term'), get_query_var('taxonomy') );
                            echo $term1->name;
                        ?>
                    </h1>
                </div>
                <div class="select_category1">
                    <select name="product_category">
                        <option value="">
                            Select Category
                        </option>
                        <?php 
                            $terms = get_terms( array(
                                'taxonomy' => 'products_categories',
                                'hide_empty' => false,
                            ) );

                            foreach( $terms as $term){
                            ?>
                                <option <?php if ($term1->slug == $term->slug) { echo "selected='selected'"; } ?> value="<?php echo site_url(); ?>/products-category/<?php echo $term->slug; ?>/">
                                    <?php echo $term->name; ?>
                                </option>
                            <?php
                            }
                        ?>

                    </select>
                </div>
                <div class="clearboth"></div>
            </div>
            
            
            <?php product_sidebar(); ?>
            
            
            <?php
                $paged = ( get_query_var( 'paged' ) ) ? absint( get_query_var( 'paged' ) ) : 1;
                
                $args = array(
                    'post_type'             => 'products',
                    'post_status'           => 'publish',
                    'ignore_sticky_posts'   => 1,
                    'paged' => $paged,
                    'posts_per_page'        => -1,
                );
                
                $args['tax_query'] = array (
                    array(
                        'taxonomy' => 'products_categories',
                        'field'    => 'slug',
                        'terms'    => array( $term1->slug )
                    )
                );
                

                $featured_query = new WP_Query( $args ); 

                if($featured_query->have_posts()) : 
                    ?>
                    <section class="category-template1" >
                            <?php

                                while($featured_query->have_posts()){
                                
                                    $featured_query->the_post();

                                    $product_id = get_the_ID();
                                    $product_link = get_permalink( $product_id );
                                    $product_title = get_the_title();

                                    $product_image = wp_get_attachment_image_src( get_post_thumbnail_id( $product_id ), 'products-catalog-image' );
                                    $product_excerpt = get_the_excerpt();
                                
                            ?>
                                    <div class="product-single-item1">
                                        <div class="product-single-item-image">
                                            <a href="<?php echo $product_link; ?>" class="product-images" title="<?php echo $product_title; ?>">
                                                <img src="<?php echo $product_image[0]; ?>" class="product-image13" alt="<?php echo $product_title; ?>" title="<?php echo $product_title; ?>" />
                                            </a>
                                        </div>
                                        <div class="product-single-item-info">
                                            
                                            <h3><?php echo $product_title; ?></h3>
                                            
                                            <p>
                                                <?php echo $product_excerpt ?>
                                            </p>
                                            
                                            <div class="call-to-actions1">
                                                <a href="javascript:void(0)" title="Request a Quote" class="request-a-quote quote_button123" data-id="<?php echo $product_id; ?>">
                                                    Request a Quote
                                                </a>

                                                <a href="<?php echo $product_link; ?>" title="More Info" class="more-info1">
                                                    More Info
                                                </a>

                                                <?php cart_updated_status(); ?>
                                            </div>
                                        </div>
                                        <div class="clearboth"></div>
                                    </div>
                            <?php
                                } 
                            ?>
                    </section>        
            <?php
                endif;
            ?>
            
            <div class="clearboth"></div>
            <div class="footer-margins1"></div>
        </div>
    </div>
</div>
<?php
get_footer();
?>