<?php

/// New Shortcode for the Products display of specific category

// [display_products posts_per_page="15"]

function display_products($atts){
    
ob_start();
            
if (isset($atts['posts_per_page']) && !empty($atts['posts_per_page'])){
    $posts_per_page = $atts['posts_per_page'];
}else{
    $posts_per_page = 16;
}


$args = array(
    'post_type'             => 'products',
    'post_status'           => 'publish',
    'ignore_sticky_posts'   => 1,
    'paged' => $paged,
    'posts_per_page'        => $posts_per_page,
    
);


$featured_query = new WP_Query( $args );  

if ($featured_query->have_posts()) {  
    $flex_id = rand(99999999, 999999999);
    ?>
        <section class="slider home-slider1">
            <div class="flexslider<?php echo $flex_id; ?> products-loop4">
                <ul class="woocommerce products clearfix products-4 slides">
                    <?php
                    while ($featured_query->have_posts()) :

                        $featured_query->the_post();

                        $product_id = $featured_query->post->ID;
                        $product_link = get_permalink( $product_id );
                        $product_title = $featured_query->post->post_title;


                        $product_image = wp_get_attachment_image_src( get_post_thumbnail_id( $product_id ), 'medium' );
                        $product_excerpt = $product->post->post_excerpt;

                    ?>
                        <li class="product-flex-slide product type-product status-publish has-post-thumbnail">
                            <div class="product-details131">
                                <a href="<?php echo $product_link; ?>" class="product-images" title="<?php echo $product_title; ?>">
                                    <img src="<?php echo $product_image[0]; ?>" class="product-image13" alt="<?php echo $product_title; ?>" title="<?php echo $product_title; ?>" />
                                </a>
                                <h2 class="product-title2"><?php echo $product_title; ?></h2>
                                <a href="<?php echo $product_link; ?>" title="<?php echo $product_title; ?>" class="learn-more2">
                                    Learn More
                                </a>
                            </div>
                        </li>
                    <?php        
                    endwhile; 
                    ?>

                </ul>
            </div>
        </section>
        <script type="text/javascript">
            jQuery(document).ready(function($){

            // store the slider in a local variable
            var $window = jQuery(window),
            flexslider = { vars:{} };

            // tiny helper function to add breakpoints
            function getGridSize() {
              return    (window.innerWidth < 450) ? 1 :
                        (window.innerWidth < 650) ? 2 :
                        (window.innerWidth < 1000) ? 3 : 4;
            }

            // check grid size on resize event
            $window.resize(function() {
              var gridSize = getGridSize();

              flexslider.vars.minItems = gridSize;
              flexslider.vars.maxItems = gridSize;
            });

            //We are above 780px, enable flexslider animation
            $('.flexslider<?php echo $flex_id; ?>').flexslider({
                animation: "slide",
                //minItems: 4,
                itemWidth: 850,
                itemMargin:25,
                minItems: getGridSize(), // use function to pull in initial value
                maxItems: getGridSize() // use function to pull in initial value
            });
        });
        </script>

<?php
}else{
    echo "No Products Found... </li>" ;
} 
wp_reset_query(); // Remember to reset
?>
        
    

<?php
return ob_get_clean();

}

add_shortcode('display_products', 'display_products');


// -------------





/// New Shortcode for the Products display of specific category

// [display_related_products category_slug="15"]

function display_related_products($atts){
    
ob_start();

$category_slug = $atts['category_slug'];

$current_product_id = get_the_ID();

$args = array(
    'post_type'             => 'products',
    'post_status'           => 'publish',
    'ignore_sticky_posts'   => 1,
    'posts_per_page'        => -1,
    'post__not_in' => array($current_product_id)
    
);

$args['tax_query'] = array (
    array(
        'taxonomy' => 'products_categories',
        'field'    => 'slug',
        'terms'    => array( $category_slug )
    )
);


$featured_query = new WP_Query( $args );  

if ($featured_query->have_posts()) {  
    $flex_id = rand(99999999, 999999999);
    ?>
        <div class="related-products1">
            <h3>
                Other Products
            </h3>
        </div>
        <section class="slider home-slider1 category-slider1">
            <div class="flexslider<?php echo $flex_id; ?> products-loop4">
                <ul class="woocommerce products clearfix products-4 slides">
                    <?php
                    while ($featured_query->have_posts()) :

                        $featured_query->the_post();

                        $product_id = $featured_query->post->ID;
                        $product_link = get_permalink( $product_id );
                        $product_title = $featured_query->post->post_title;


                        $product_image = wp_get_attachment_image_src( get_post_thumbnail_id( $product_id ), 'medium' );
                        $product_excerpt = $product->post->post_excerpt;

                    ?>
                        <li class="product-flex-slide product type-product status-publish has-post-thumbnail">
                            <div class="product-details131">
                                <a href="<?php echo $product_link; ?>" class="product-images" title="<?php echo $product_title; ?>">
                                    <img src="<?php echo $product_image[0]; ?>" class="product-image13" alt="<?php echo $product_title; ?>" title="<?php echo $product_title; ?>" />
                                </a>
                                <h2 class="product-title2"><?php echo $product_title; ?></h2>
                                <a href="<?php echo $product_link; ?>" title="<?php echo $product_title; ?>" class="learn-more2">
                                    Learn More
                                </a>
                            </div>
                        </li>
                    <?php        
                    endwhile; 
                    ?>

                </ul>
            </div>
        </section>
        <script type="text/javascript">
            jQuery(document).ready(function($){

            // store the slider in a local variable
            var $window = jQuery(window),
            flexslider = { vars:{} };

            // tiny helper function to add breakpoints
            function getGridSize() {
              return    (window.innerWidth < 450) ? 1 :
                        (window.innerWidth < 650) ? 2 :
                        (window.innerWidth < 1000) ? 3 : 3;
            }

            // check grid size on resize event
            $window.resize(function() {
              var gridSize = getGridSize();

              flexslider.vars.minItems = gridSize;
              flexslider.vars.maxItems = gridSize;
            });

            //We are above 780px, enable flexslider animation
            $('.flexslider<?php echo $flex_id; ?>').flexslider({
                animation: "slide",
                //minItems: 4,
                itemWidth: 850,
                itemMargin:25,
                minItems: getGridSize(), // use function to pull in initial value
                maxItems: getGridSize() // use function to pull in initial value
            });
        });
        </script>

<?php
}else{
    echo "No Products Found... </li>" ;
} 
wp_reset_query(); // Remember to reset
?>
        
    

<?php
return ob_get_clean();

}

add_shortcode('display_related_products', 'display_related_products');


// -------------




/*************************************************************************************/


/*
* Creating Team Post Type
*/

function custom_post_type3() {

	$labels = array(
            'name'                => _x( 'Products', 'Post Type General Name', 'twentythirteen' ),
            'singular_name'       => _x( 'Product', 'Post Type Singular Name', 'twentythirteen' ),
            'menu_name'           => __( 'Products', 'twentythirteen' ),
            'parent_item_colon'   => __( 'Parent Product', 'twentythirteen' ),
            'all_items'           => __( 'All Products', 'twentythirteen' ),
            'view_item'           => __( 'View Product', 'twentythirteen' ),
            'add_new_item'        => __( 'Add New Product', 'twentythirteen' ),
            'add_new'             => __( 'Add New', 'twentythirteen' ),
            'edit_item'           => __( 'Edit Product', 'twentythirteen' ),
            'update_item'         => __( 'Update Product', 'twentythirteen' ),
            'search_items'        => __( 'Search Product', 'twentythirteen' ),
            'not_found'           => __( 'Not Found', 'twentythirteen' ),
            'not_found_in_trash'  => __( 'Not found in Trash', 'twentythirteen' ),
	);
	
	
	$args = array(
            'label'               => __( 'products', 'twentythirteen' ),
            'description'         => __( 'Products', 'twentythirteen' ),
            'labels'              => $labels,
            // Features this CPT supports in Post Editor
            'supports'            => array( 'title', 'editor', 'excerpt', 'author', 'thumbnail', 'comments', 'revisions', 'custom-fields', ),
            // You can associate this CPT with a taxonomy or custom taxonomy. 
            'taxonomies'          => array( 'genres' ),
            'hierarchical'        => false,
            'menu_position'       => 7,
            'can_export'          => true,
            'publicly_queryable'  => true,
            'capability_type'     => 'post',
            'public' => true,  
            'publicly_queryable' => true,  
            'show_ui' => true, 
            'exclude_from_search' => false,  
            'show_in_nav_menus' => true,
            'has_archive' => true,  
            'rewrite' => array('slug' => 'products')
	);
	
	register_post_type( 'products', $args );

}

add_action( 'init', 'custom_post_type3', 0 );



//hook into the init action and call create_book_taxonomies when it fires
add_action( 'init', 'create_topics_hierarchical_taxonomy', 0 );

//create a custom taxonomy name it topics for your posts

function create_topics_hierarchical_taxonomy() {

// Add new taxonomy, make it hierarchical like categories
//first do the translations part for GUI

  $labels = array(
    'name' => _x( 'Categories', 'taxonomy general name' ),
    'singular_name' => _x( 'Category', 'taxonomy singular name' ),
    'search_items' =>  __( 'Search Categories' ),
    'all_items' => __( 'All Categories' ),
    'parent_item' => __( 'Parent Category' ),
    'parent_item_colon' => __( 'Parent Category:' ),
    'edit_item' => __( 'Edit Category' ), 
    'update_item' => __( 'Update Category' ),
    'add_new_item' => __( 'Add New Category' ),
    'new_item_name' => __( 'New Category Name' ),
    'menu_name' => __( 'Categories' ),
  ); 	

// Now register the taxonomy

  register_taxonomy('products_categories',array('products'), array(
    'hierarchical' => true,
    'labels' => $labels,
    'show_ui' => true,
    'show_admin_column' => true,
    'query_var' => true,
    'rewrite' => array( 'slug' => 'products-category' ),
  ));

}


function product_sidebar(){
    ?>
        <section class="sidebar31">
            <div class="quote-box1">
                <div class="quote-box-inner">
                    <div class="quote-icon1">
                        <i class="fa fa-pencil-square-o" aria-hidden="true"></i>
                    </div>
                    <div class="quote-text">
                        <h4 class="quote-count">
                            <a href="<?php echo site_url(); ?>/quotation-request/">
                                <?php
                                    if(isset($_COOKIE['user_cart_products'])){

                                        $user_cart_products = $_COOKIE['user_cart_products'];
                                        $user_cart_products = stripslashes($_COOKIE['user_cart_products']);
                                        $user_cart_products = unserialize($user_cart_products);

                                        if (isset($user_cart_products) && is_array($user_cart_products) && count($user_cart_products) > 0){
                                            echo $count33 = count($user_cart_products);
                                        }else{
                                            echo "0";
                                        }
                                    }else{
                                        echo "0";
                                    }
                                ?>
                            </a>
                        </h4>
                        <span>
                            <?php
                                if (isset($count33) && $count33 == 1){
                                    $s = "";
                                }else{
                                    $s = "s";
                                }
                            ?>
                            Quote<?php echo $s; ?> Requested
                        </span>
                    </div>
                    <div class="clearboth"></div>
                </div>
            </div>
            <div class="categories-list1">
                <ul>
                    <?php 
                        $terms = get_terms( array(
                            'taxonomy' => 'products_categories',
                            'hide_empty' => false,
                        ) );

                        foreach( $terms as $term){
                        ?>
                            <li>
                                <a href="<?php echo site_url(); ?>/products-category/<?php echo $term->slug; ?>/">
                                    <?php echo $term->name; ?>
                                </a>
                            </li>
                        <?php
                        }
                    ?>

                </ul>
            </div>
        </section>
    <?php
}


function cart_updated_status(){ 
    ?>
<div class="updated_cart">
    Product has been added to 
    <a href="<?php echo site_url(); ?>/quotation-request/" title="Quotation Request">
        Quotation Request
    </a>
</div>
    <?php
}