<?php
/*************************************************************************************/


/*
* Creating  Post Type
*/

function custom_post_type5() {

	$labels = array(
            'name'                => _x( 'Partners', 'Post Type General Name', 'twentythirteen' ),
            'singular_name'       => _x( 'Partner', 'Post Type Singular Name', 'twentythirteen' ),
            'menu_name'           => __( 'Partners', 'twentythirteen' ),
            'parent_item_colon'   => __( 'Parent Partner', 'twentythirteen' ),
            'all_items'           => __( 'All Partners', 'twentythirteen' ),
            'view_item'           => __( 'View Partner', 'twentythirteen' ),
            'add_new_item'        => __( 'Add New Partner', 'twentythirteen' ),
            'add_new'             => __( 'Add New', 'twentythirteen' ),
            'edit_item'           => __( 'Edit Partner', 'twentythirteen' ),
            'update_item'         => __( 'Update Partner', 'twentythirteen' ),
            'search_items'        => __( 'Search Partner', 'twentythirteen' ),
            'not_found'           => __( 'Not Found', 'twentythirteen' ),
            'not_found_in_trash'  => __( 'Not found in Trash', 'twentythirteen' ),
	);
	
	
	$args = array(
            'label'               => __( 'partner', 'twentythirteen' ),
            'description'         => __( 'Partners', 'twentythirteen' ),
            'labels'              => $labels,
            // Features this CPT supports in Post Editor
            'supports'            => array( 'title', 'editor', 'excerpt', 'author', 'thumbnail', 'comments', 'revisions', 'custom-fields', ),
            // You can associate this CPT with a taxonomy or custom taxonomy. 
            'taxonomies'          => array( 'genres' ),
            'hierarchical'        => false,
            'menu_position'       => 7,
            'can_export'          => true,
            'publicly_queryable'  => true,
            'capability_type'     => 'post',
            'public' => true,  
            'publicly_queryable' => true,  
            'show_ui' => true, 
            'exclude_from_search' => false,  
            'show_in_nav_menus' => true,
            'has_archive' => true,  
            'rewrite' => array('slug' => 'partners')
	);
	
	register_post_type( 'partners', $args );

}

add_action( 'init', 'custom_post_type5', 0 );




function partners_sidebar(){
    ?>
        <section class="sidebar31">
            <div class="categories-list1">
                <ul>
                    <?php 
                    
                        $paged = ( get_query_var( 'paged' ) ) ? absint( get_query_var( 'paged' ) ) : 1;
                
                        $args = array(
                            'post_type'             => 'partners',
                            'post_status'           => 'publish',
                            'ignore_sticky_posts'   => 1,
                            'paged' => $paged,
                            'posts_per_page'        => -1,
                        );


                        $featured_query = new WP_Query( $args ); 
                        

                        if($featured_query->have_posts()) : 
                        ?>
                            <?php

                            while($featured_query->have_posts()){

                                $featured_query->the_post();

                                $product_id = get_the_ID();
                                $product_link = get_permalink( $product_id );
                                $product_title = get_the_title();

                                $product_image = wp_get_attachment_image_src( get_post_thumbnail_id( $product_id ), 'products-catalog-image' );
                                $product_excerpt = get_the_excerpt();
                                
                            ?>
                                <li>
                                    <a href="<?php echo $product_link; ?>">
                                        <?php echo $product_title; ?>
                                    </a>
                                </li>
                            <?php
                                } 
                            ?>
                        <?php
                        endif;
                        ?>

                </ul>
            </div>
        </section>
    <?php
}