<?php



function news_sidebar(){
    ?>
        <section class="sidebar31">
            <div class="categories-list1">
                <ul>
                    <?php 
                    
                        $paged = ( get_query_var( 'paged' ) ) ? absint( get_query_var( 'paged' ) ) : 1;
                
                        $args = array(
                            'post_type'             => 'post',
                            'post_status'           => 'publish',
                            'ignore_sticky_posts'   => 1,
                            'paged' => $paged,
                            'posts_per_page'        => 10,
                        );


                        $featured_query = new WP_Query( $args ); 
                        
                        

                        if($featured_query->have_posts()) : 
                        ?>
                            <?php

                            while($featured_query->have_posts()){

                                $featured_query->the_post();

                                $product_id = get_the_ID();
                                $product_link = get_permalink( $product_id );
                                $product_title = get_the_title();

                                $product_image = wp_get_attachment_image_src( get_post_thumbnail_id( $product_id ), 'products-catalog-image' );
                                $product_excerpt = get_the_excerpt();
                                
                            ?>
                                <li>
                                    <a href="<?php echo $product_link; ?>">
                                        <?php echo $product_title; ?>
                                        <br />
                                        <?php the_date(); ?> 
                                    </a>
                                </li>
                            <?php
                                } 
                            ?>
                        <?php
                        endif;
                        ?>

                </ul>
                <div class="older-posts1">
                    <a href="<?php echo site_url(); ?>/latest-news/">
                        Older News
                    </a>
                </div>
            </div>
        </section>
    <?php
}