<?php
/*************************************************************************************/


/*
* Creating  Post Type
*/

function custom_post_type4() {

	$labels = array(
            'name'                => _x( 'Careers', 'Post Type General Name', 'twentythirteen' ),
            'singular_name'       => _x( 'Career', 'Post Type Singular Name', 'twentythirteen' ),
            'menu_name'           => __( 'Careers', 'twentythirteen' ),
            'parent_item_colon'   => __( 'Parent Career', 'twentythirteen' ),
            'all_items'           => __( 'All Careers', 'twentythirteen' ),
            'view_item'           => __( 'View Career', 'twentythirteen' ),
            'add_new_item'        => __( 'Add New Career', 'twentythirteen' ),
            'add_new'             => __( 'Add New', 'twentythirteen' ),
            'edit_item'           => __( 'Edit Career', 'twentythirteen' ),
            'update_item'         => __( 'Update Career', 'twentythirteen' ),
            'search_items'        => __( 'Search Career', 'twentythirteen' ),
            'not_found'           => __( 'Not Found', 'twentythirteen' ),
            'not_found_in_trash'  => __( 'Not found in Trash', 'twentythirteen' ),
	);
	
	
	$args = array(
            'label'               => __( 'career', 'twentythirteen' ),
            'description'         => __( 'Careers', 'twentythirteen' ),
            'labels'              => $labels,
            // Features this CPT supports in Post Editor
            'supports'            => array( 'title', 'editor', 'excerpt', 'author', 'thumbnail', 'comments', 'revisions', 'custom-fields', ),
            // You can associate this CPT with a taxonomy or custom taxonomy. 
            'taxonomies'          => array( 'genres' ),
            'hierarchical'        => false,
            'menu_position'       => 7,
            'can_export'          => true,
            'publicly_queryable'  => true,
            'capability_type'     => 'post',
            'public' => true,  
            'publicly_queryable' => true,  
            'show_ui' => true, 
            'exclude_from_search' => false,  
            'show_in_nav_menus' => true,
            'has_archive' => true,  
            'rewrite' => array('slug' => 'careers')
	);
	
	register_post_type( 'careers', $args );

}

add_action( 'init', 'custom_post_type4', 0 );




function careers_sidebar(){
    ?>
        <section class="sidebar31">
            <div class="categories-list1">
                <ul>
                    <?php 
                    
                        $paged = ( get_query_var( 'paged' ) ) ? absint( get_query_var( 'paged' ) ) : 1;
                
                        $args = array(
                            'post_type'             => 'careers',
                            'post_status'           => 'publish',
                            'ignore_sticky_posts'   => 1,
                            'paged' => $paged,
                            'posts_per_page'        => 10,
                        );


                        $featured_query = new WP_Query( $args ); 
                        
                        

                        if($featured_query->have_posts()) : 
                        ?>
                            <?php

                            while($featured_query->have_posts()){

                                $featured_query->the_post();

                                $product_id = get_the_ID();
                                $product_link = get_permalink( $product_id );
                                $product_title = get_the_title();

                                $product_image = wp_get_attachment_image_src( get_post_thumbnail_id( $product_id ), 'products-catalog-image' );
                                $product_excerpt = get_the_excerpt();
                                
                            ?>
                                <li>
                                    <a href="<?php echo $product_link; ?>">
                                        <?php echo $product_title; ?>
                                        <br />
                                        <?php the_date(); ?> 
                                    </a>
                                </li>
                            <?php
                                } 
                            ?>
                        <?php
                        endif;
                        ?>

                </ul>
                <div class="older-posts1">
                    <a href="<?php echo site_url(); ?>/careers/">
                        Older Vacancies
                    </a>
                </div>
            </div>
        </section>
    <?php
}