<?php 

add_action( 'wp_enqueue_scripts', 'divi_child_enqueue_styles', 50);

function divi_child_enqueue_styles() {

    wp_enqueue_style( 'parent-style', get_template_directory_uri() . '/style.css' );

}


if( function_exists('acf_add_options_page') ) {
	acf_add_options_page();
}



include('style.php');

include('functions/products.php');

include('functions/careers.php');

include('functions/partners.php');

include('functions/latest-news.php');



add_filter('widget_text','do_shortcode');

remove_filter( 'the_content', 'wpautop' );
remove_filter( 'the_excerpt', 'wpautop' );


// Custom Image Sizes
add_image_size( 'products-catalog-image', 368, 250, true );
//------------------------


if( function_exists('acf_add_options_page') ) {
    
    $option_page = acf_add_options_page(array(
            'page_title' 	=> 'Header Options',
            'menu_title' 	=> 'Header',
            'parent_slug' 	=> 'acf-options',
            'capability' 	=> 'edit_posts',
            'redirect' 	=> false
    ));

    $option_page = acf_add_options_page(array(
            'page_title' 	=> 'Featured Slider',
            'menu_title' 	=> 'Featured Slider',
            'parent_slug' 	=> 'acf-options',
            'capability' 	=> 'edit_posts',
            'redirect' 	=> false
    ));
    
    $option_page = acf_add_options_page(array(
            'page_title' 	=> 'Footer Options',
            'menu_title' 	=> 'Footer',
            'parent_slug' 	=> 'acf-options',
            'capability' 	=> 'edit_posts',
            'redirect' 	=> false
    ));
    
    
    
}



/** Footer Social Widget Shortcode  **/

function featured_slider($atts){
    
ob_start();
?>

<div class="featured_slider">
    <div class="slider-left">
        <?php if (get_field('headline22', 'option')) {  ?>
            <h2>
                <?php the_field('headline22', 'option'); ?>
            </h2>
        <?php } ?>
        <?php if (get_field('content22', 'option')) {  ?>
            <?php the_field('content22', 'option'); ?>
        <?php } ?>
    </div>
    <div class="slider-right">
        <?php if(have_rows('slider22', 'option')): ?>
            <?php
                $flex_id = rand(99999999, 999999999);
            ?>
            <section class="slider home-slider1">
                <div class="flexslider<?php echo $flex_id; ?> products-loop4 featured_slider123">
                    <ul class="woocommerce products clearfix products-4 slides">
                        <?php while(have_rows('slider22', 'option')): the_row(); ?>
                            <li class="product-flex-slide product type-product status-publish has-post-thumbnail">
                                <div class="product-details131">
                                    <img src="<?php the_sub_field('image22'); ?>" class="product-image13" alt="<?php the_sub_field('image_alt_text'); ?>" title="<?php the_sub_field('image_alt_text'); ?>" />
                                </div>
                            </li>
                        <?php endwhile; ?> 
                    </ul>
                </div>
            </section>
            <script type="text/javascript">
                jQuery(document).ready(function($){

                // store the slider in a local variable
                var $window = jQuery(window),
                flexslider = { vars:{} };

                // tiny helper function to add breakpoints
                function getGridSize() {
                  return    (window.innerWidth < 450) ? 1 :
                            (window.innerWidth < 650) ? 1 :
                            (window.innerWidth < 1000) ? 1 : 1;
                }

                // check grid size on resize event
                $window.resize(function() {
                  var gridSize = getGridSize();

                  flexslider.vars.minItems = gridSize;
                  flexslider.vars.maxItems = gridSize;
                });

                //We are above 780px, enable flexslider animation
                $('.flexslider<?php echo $flex_id; ?>').flexslider({
                    animation: "fade",
                    //minItems: 4,
                    itemWidth: 850,
                    itemMargin:25,
                    minItems: getGridSize(), // use function to pull in initial value
                    maxItems: getGridSize() // use function to pull in initial value
                });
            });
            </script>
        <?php 
        endif;
        wp_reset_query(); // Remember to reset
        ?>   
    </div>
    <div class="clearboth"></div>
</div>
        
<?php
return ob_get_clean();
}

add_shortcode('featured_slider', 'featured_slider');






/** Footer Social Widget Shortcode  **/

function get_social_buttons($atts){
    
ob_start();
?>

<div class="footer-sidebar-social">
    <?php if(have_rows('social_media_button', 'option')): ?>
        <?php while(have_rows('social_media_button', 'option')): the_row(); ?>
            <a href="<?php the_sub_field('link22'); ?>" target="_blank">
                <?php the_sub_field('icon22'); ?>
            </a>
        <?php endwhile; ?>
    <?php endif; ?>
</div>
        
<?php
return ob_get_clean();
}

add_shortcode('get_social_buttons', 'get_social_buttons');





/** Footer Call to Action Links  **/

function footer_call_to_action($atts){
    
ob_start();
?>


<?php if(have_rows('footer_call_to_actions', 'option')): ?>
    <div class="footer-call-to-actions">
        <?php while(have_rows('footer_call_to_actions', 'option')): the_row(); ?>
            <div class="contact-item1">
                <?php
                    if(get_sub_field('contact_link')){
                    ?>
                        <a href="<?php the_sub_field('contact_link'); ?>">
                    <?php
                    }
                ?>
                    <?php the_sub_field('contact_icon'); ?>
                    <span class="contact_description">
                        <?php the_sub_field('contact_description'); ?>
                    </span>
                    <span class="clearboth"></span>
                <?php
                    if(get_sub_field('contact_link')){
                    ?>
                        </a>
                    <?php
                    }
                ?>
            </div>
            <span class="clearboth"></span>
        <?php endwhile; ?>
    </div>
<?php endif; ?>


        
<?php        

return ob_get_clean();

}

add_shortcode('footer_call_to_action', 'footer_call_to_action');





/** Product Search Form  **/

function product_search($atts){
    
ob_start();
?>

<div class="product_search">
    <form class="search_apps1">
        <select name="select_category_app">
            <option value="">
                Search by Application
            </option>
            <?php 
                $terms = get_terms( array(
                    'taxonomy' => 'products_categories',
                    'hide_empty' => false,
                ) );

                foreach( $terms as $term){
                ?>
                    <option value="<?php echo $term->slug; ?>">
                        <?php echo $term->name; ?>
                    </option>
                <?php
                }
            ?>
        </select>
        <i class="fa fa-refresh fa-spin fa-3x fa-fw margin-bottom searching1"></i>
        <select name="select_products">
            <option>
                Select Products
            </option>
        </select>
        <input type="submit" class="search_category" value="Search" />
    </form>
</div>

        
<?php        

return ob_get_clean();

}

add_shortcode('product_search', 'product_search');