<?php
/*
    Template Name: Quotation Request
*/
get_header();
?>
<div id="et-main-area">
    <div id="main-content">
        <div class=" et_pb_row et_pb_row_0 featured-slider-section">
            <?php 
                echo do_shortcode('[featured_slider]');
            ?>
            
            <div class="title_row1 cart_page_template">
                <div class="page_title1">
                    <h1>
                        <?php the_title(); ?>
                    </h1>
                </div>
                <div class="right_side1">
                    <a href="<?php echo site_url(); ?>/products/" title="Back to Products">
                        Back to Products
                    </a>
                </div>
                <div class="clearboth"></div>
            </div>
            
            <?php
            
            
            if(isset($_COOKIE['user_cart_products'])){
            
                $user_cart_products = $_COOKIE['user_cart_products'];
                $user_cart_products = stripslashes($_COOKIE['user_cart_products']);
                $user_cart_products = unserialize($user_cart_products);
                
                //echo count($user_cart_products);
            
            ?>
                
                    <?php 
                        if (isset($user_cart_products) && is_array($user_cart_products) && count($user_cart_products) > 0){
                            ?>
                            <div class="cart_container1">
                            <?php
                                foreach ($user_cart_products as $cart_item){

                                    $product_id = $cart_item;
                                    $product_link = get_permalink( $product_id );
                                    $product_title = get_the_title( $product_id );
                                    $product_image = wp_get_attachment_image_src( get_post_thumbnail_id( $product_id ), 'medium' );


                                    global $post;
                                    $terms = get_the_terms( $product_id , 'products_categories' ); 
                                    foreach( $terms as $term ) { 
                                        $category_name = $term->name;
                                        $category_slug = $term->slug;
                                        break;
                                    }  

                                    ?>
                                    <div class="cart_box_container1">
                                        <div class="cart_product_image">
                                            <a href="<?php echo $product_link; ?>" title="<?php echo $product_title; ?>" target="_blank">
                                                <img src="<?php echo $product_image[0]; ?>" alt="<?php echo $product_title; ?>" title="<?php echo $product_title; ?>" />
                                            </a>
                                        </div>
                                        <div class="cart_product_category">
                                            <div class="cart_product_category_inner">
                                                <a href="<?php echo site_url(); ?>/products-category/<?php echo $category_slug; ?>">
                                                    <?php echo $category_name; ?>
                                                </a>
                                            </div>    
                                        </div>
                                        <div class="cart_product_name">
                                            <div class="cart_product_name_inner">
                                                <a href="<?php echo $product_link; ?>">
                                                    <?php echo $product_title; ?>
                                                </a>
                                            </div> 
                                        </div>
                                        <div class="cart_product_view">
                                            <div class="cart_product_view_inner">
                                                <a href="<?php echo $product_link; ?>">
                                                    View Product 
                                                </a>
                                            </div> 
                                        </div>
                                        <div class="cart_product_remove">
                                            <div class="cart_product_remove_inner">
                                                <a href="javascript:void(0);" class="remove-product1" data-id="<?php echo $product_id; ?>">
                                                    <img src="<?php echo get_stylesheet_directory_uri(); ?>/images/close.png" />
                                                </a>
                                            </div> 
                                        </div>
                                        <div class="clearboth"></div>
                                    </div>
                                    <?php
                                }
                            ?>
                            </div>
                            
            
                            <form class="form_container1">
                                <h2>
                                    Request Quote
                                </h2>

                                <div class="form-inner3">
                                    <div class="form-left123">
                                        <div class="input-box1">
                                            <label for="fname">
                                                First Name
                                            </label>
                                            <input type="text" name="fname" id="fname" />
                                        </div>
                                        <div class="input-box1">
                                            <label for="cname">
                                                Company Name
                                            </label>
                                            <input type="text" name="cname" id="cname" />
                                        </div>
                                        <div class="input-box1">
                                            <label for="email">
                                                Email Address
                                            </label>
                                            <input type="text" name="email" id="email" />
                                        </div>
                                        <div class="input-box1">
                                            <label for="address">
                                                Full Address
                                            </label>
                                            <textarea name="address" id="address"></textarea>
                                        </div>
                                    </div>
                                    <div class="form-right123">
                                        <div class="input-box1">
                                            <label for="lname">
                                                Last Name
                                            </label>
                                            <input type="text" name="lname" id="lname" />
                                        </div>
                                        <div class="input-box1">
                                            <label for="designation">
                                                Designation / Position
                                            </label>
                                            <input type="text" name="designation" id="designation" />
                                        </div>
                                        <div class="input-box1">
                                            <label for="phone">
                                                Phone No.
                                            </label>
                                            <input type="text" name="phone" id="phone" />
                                        </div>
                                        <div class="input-box1">
                                            <label for="notes">
                                                Notes
                                            </label>
                                            <textarea name="notes" id="notes"></textarea>
                                        </div>
                                    </div>
                                    <div class="clearboth"></div>
                                    <input class="form_submit123" type="button" value="Send" />
                                    <div class="clearboth"></div>
                                </div>
                            </form>
                            
                            <?php
                        }else{
                            ?>
                                <div class="cart_container1">
                                    <div class="cart_empty1">
                                        <h2>You Have Not Requested For Quotes</h2>
                                    </div>
                                </div>    
                            <?php
                        }
                    ?>
                
            <?php } else { ?>
                
                <div class="cart_container1">
                    <div class="cart_empty1">
                        <h2>You Have Not Requested For Quotes</h2>
                    </div>
                </div>
            
            <?php } ?>
            
            
            
            
            
            
            
            
            
            <div class="footer-margins1"></div>
        </div>
    </div>
</div>
<?php
get_footer();
?>