<?php
get_header();
?>
<div id="et-main-area">
    <div id="main-content">
        <div class=" et_pb_row et_pb_row_0 featured-slider-section">
            <?php 
                echo do_shortcode('[featured_slider]');
            ?>
            
            <div class="title_row1">
                <div class="page_title1">
                    <h1>
                        Our Products
                    </h1>
                </div>
                <div class="select_category1">
                    <select name="product_category">
                        <option value="">
                            Select Category
                        </option>
                        <?php 
                            $terms = get_terms( array(
                                'taxonomy' => 'products_categories',
                                'hide_empty' => false,
                            ) );

                            foreach( $terms as $term){
                            ?>
                                <option value="<?php echo site_url(); ?>/products-category/<?php echo $term->slug; ?>/">
                                    <?php echo $term->name; ?>
                                </option>
                            <?php
                            }
                        ?>

                    </select>
                </div>
                <div class="clearboth"></div>
            </div>
            <?php
                $paged = ( get_query_var( 'paged' ) ) ? absint( get_query_var( 'paged' ) ) : 1;
                
                $args = array(
                    'post_type'             => 'products',
                    'post_status'           => 'publish',
                    'ignore_sticky_posts'   => 1,
                    'paged' => $paged,
                    'posts_per_page'        => -1,
                );
                
                
                $featured_query = new WP_Query( $args ); 
                
                
                if($featured_query->have_posts()) : 
                    ?>
                    <section class="slider home-slider1 products-loop4 product-archive1" >
                        <ul class="woocommerce products clearfix products-4 slides">
                            <?php

                                while($featured_query->have_posts()){
                                
                                    $featured_query->the_post();

                                    $product_id = get_the_ID();
                                    $product_link = get_permalink( $product_id );
                                    $product_title = get_the_title();


                                    $product_image = wp_get_attachment_image_src( get_post_thumbnail_id( $product_id ), 'products-catalog-image' );
                                    $product_excerpt = $product->post->post_excerpt;
                                
                            ?>
                                    <li class="product-flex-slide product type-product status-publish has-post-thumbnail product-single-item">
                                        <div class="product-details131">
                                            <a href="<?php echo $product_link; ?>" class="product-images" title="<?php echo $product_title; ?>">
                                                <img src="<?php echo $product_image[0]; ?>" class="product-image13" alt="<?php echo $product_title; ?>" title="<?php echo $product_title; ?>" />
                                            </a>
                                            <h2 class="product-title2"><?php echo $product_title; ?></h2>
                                            <a href="<?php echo $product_link; ?>" title="<?php echo $product_title; ?>" class="learn-more2">
                                                Learn More
                                            </a>
                                        </div>
                                    </li>
                            <?php
                                } 
                            ?>
                        </ul>
                        
<!--                        <div class="loop-pagination">
                            <div class="container14">
                                <?php 
                                
                                    $big = 9999999999999999999; // need an unlikely integer

                                    echo paginate_links( array(
                                        'current' => max(1, get_query_var('paged')),
                                                'total' => $featured_query->max_num_pages,
                                                'base' => get_pagenum_link(1) . '%_%',  
                                                    'format' => 'page/%#%',
                                            ) );

                                ?>
                            </div>
                            <div class="clearboth"></div>
                        </div>-->
                        
                        
                    </section>      
            
                    
            <?php
                endif;
            ?>
            
            
                
            <div class="footer-margins1"></div>
        </div>
    </div>
</div>
<?php
get_footer();
?>