<?php

// Load WordPress 
define('WP_USE_THEMES', false);
require_once( explode( "wp-content" , __FILE__ )[0] . "wp-load.php" );

GLOBAL $wpdb;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

$cat = stripslashes($_POST['cat']);

$args = array(
    'post_type'             => 'products',
    'post_status'           => 'publish',
    'ignore_sticky_posts'   => 1,
    'paged' => $paged,
    'posts_per_page'        => -1,
);

$args['tax_query'] = array (
    array(
        'taxonomy' => 'products_categories',
        'field'    => 'slug',
        'terms'    => array( $cat )
    )
);


$featured_query = new WP_Query( $args );

if($featured_query->have_posts()) { 
    ?>
    <option value="">
        Select Product
    </option>
    <?php  
    while($featured_query->have_posts()){

        $featured_query->the_post();

        $product_id = get_the_ID();
        $product_link = get_permalink( $product_id );
        $product_title = get_the_title();

        $product_image = wp_get_attachment_image_src( get_post_thumbnail_id( $product_id ), 'products-catalog-image' );
        $product_excerpt = get_the_excerpt();

    ?>
        <option value="<?php echo $product_link; ?>">
            <?php echo $product_title; ?>
        </option>
    <?php
        } 
    ?>       
<?php
}else{
    echo "nothing..";
}
?>

